;
;***********************
;    DEMO TIMER 8253   *
;    EXPERIMENT 0BH    *
;***********************
;
        CPU  "8085.TBL"
        HOF  "INT8"
;
         ORG  2100H

CWD:     EQU  0BFH
CH0:     EQU  0BCH
CTRL:    EQU  0BBH
GATE:    EQU  0B8H
RST38H:  EQU  2065H
LED:     EQU  0BAH
SYSCAL:  EQU  2
DELAY:   EQU  0FH
SEGM:    EQU  1
DIGIT:   EQU  2
;
        DI
        XRA  A
        STA  COL
        MVI  A,80H
        OUT  CTRL
        LXI  H,INT
        SHLD RST38H
        MVI  A,00010111B
        OUT  CWD
        MVI  A,50H
        OUT  CH0

        MVI  D,1
        MVI  A,1
        OUT  GATE
        EI
;
LOOP:   MOV  A,D
        OUT  LED
        MVI  A,DELAY
        MVI  B,50H
        RST  SYSCAL
;
        MOV  A,D
        RLC
        MOV  D,A
        JMP  LOOP
;
INT:    PUSH PSW
        PUSH B
        PUSH H
        MVI  A,0
        NOP
        NOP
        OUT  SEGM

        LDA  COL
        OUT  DIGIT
        MOV  C,A
        INR  A
        CPI  6
        JNZ  INT1
        MVI  A,0
;
INT1:   STA  COL
        MVI  B,0

        LXI  H,TABLE
        DAD  B
        MOV  A,M
        OUT  SEGM
        MVI  A,1
        OUT  GATE
        POP  H
        POP  B
        POP  PSW
        EI
        RET
;
TABLE:   DFB 3FH,06H,5BH,4FH,66H,6DH

         ORG   3000H
COL:     DFS   1

